'use strict';
define(function () {
  const itvUtilsFactory = function (itvSoumFactory2, $q, gaDomUtils,
    $filter, $http, PortalsFactory) {


    const resources = {};

    const getPortalId = () => {
      let portalid = angular.module('gcMain').portalid;
      if (portalid == undefined || portalid == '') {
        portalid = PortalsFactory.getPortalId();
      }
      return portalid;
    };

    const portalid = getPortalId();


    const getHeadersFrom = (p) => {
      let part = p;
      if (p.part) {
        part = p.part;
      }
      if (part.objValeur) {
        return part.objValeur.headers;
      }
      else if (part.partHeaders) {
        return part.partHeaders;
      }
      else {
        return part.headers;
      }
    };


    const getCodesOfPart = (part) => {
      if (part) {
        const headers = getHeadersFrom(part);
        return headers.map((header) => {
          return header ? header.code : undefined;
        });
      }
    };



    /**
     * Suppression de la layer reçue en paramétre ds layers de la carte.
     * Paser par cette fonction permet juste de ne pas arrêter l'exécution
     * lorsqu'OpenLayers plante dans un "ForEach" en essayant d'enlever
     * le layer de la carte.
     *
     * @param {*} layer
     */
    const removeLayer = (scope, layer) => {
      try {
        scope.map.removeLayer(layer);
      }
      catch (e) {
        console.log('removeLayer: Erreur attrapée: '+e.stack);
      }
    };


    const removeLayerByName = (scope, layerName) => {
      const layers = scope.map.getLayers().getArray();
      for(const layer of layers) {
        if (layerName === layer.getProperties().name) {
          removeLayer(scope, layer);
        }
      }
    };


    const removeLayers = (scope, insertInd) => {
      itvSoumFactory2.getitvoperationalLayers().forEach((featureLayer) => {
        const layerName = featureLayer.getProperties().name;
        const layers = scope.map.getLayers().getArray();
        for (let iLayer = layers.length-1; iLayer >=0 ; iLayer--) {
          const layer = layers[iLayer];
          if (layerName === layer.getProperties().name) {
            removeLayer(scope, layer);
          }
        }
        if (insertInd) {
          scope.map.getLayers().insertAt(insertInd, featureLayer);
        }
      });
    };


    const selectText = (polygon, eltName) => {
      if (eltName === undefined) {
        eltName = '.textCenter';
      }
      let header = polygon.partHeader;
      if (!header) {
        header = polygon;
      }
      const ob = {
        matched: header.validated,
        matchedAuto: header.matchedAutomatically,
      };
      d3.selectAll(eltName)
        .text(itvSoumFactory2.iconmatch(ob, 'text'))
        .style('fill', itvSoumFactory2.iconmatch(ob, 'color'))
        .style('stroke', itvSoumFactory2.iconmatch(ob, 'color'));
    };


    /**
     * Récupération de l'identifiant de l'objet pour dessin sur carte.
     * -1- A ce jour cette fonction n'est utilisé que pour le dessin sur carte.
     * -2- C'est l'id GeoTools qui doit être utilisé
     *     (donc l objectid dans le cas ArcGIS).
     *
     * @param {*} header : code référençant l'id de l'ouvrage
     *                     ('AAA', 'AAD', ...).
     * @param {*} ind : ind de l'ouvrage quand il y a une liste
     * @returns identifiant GeoTools de l'ouvrage
     */
    const getIdValue = (header, ind, forceGettingValue) => {
      if (ind != undefined) {
        if (header.featIds4Net && ind<header.featIds4Net.length && !forceGettingValue) {
          return header.featIds4Net[ind];
        }
        else if (header.values && ind < header.values.length) {
          return header.values[ind];
        }
        else if (header.featId4Net) {
          //-- Cas où côté serveur le code AAA pointe
          //-- sur une canalisation existante.
          return header.featId4Net;
        }
        else if (header.code === '@01') {
          //-- Cas du branchement pour inspection de branchement
          return header.value;
        }
      }
      else {
        if (header.featId4Net && !forceGettingValue) {
          return header.featId4Net;
        }
        else {
          return header.value;
        }
      }
    };


    /**
     * position : 'center', 'alone', 'amont', ou 'aval'
     * textPosition : 'textCenter', 'textAmont', ou 'textAval'
     */
    const constructFeature = (scope, position, polygon, map, d3,
      featureLayerPos) => {
      const def = $q.defer();
      const mapProjCode = scope.map.getView().getProjection().getCode();
      checkFeatureTypeUID(polygon);
      itvSoumFactory2.drawFeature(polygon.partHeader.featUid,
        getIdValue(polygon.partHeader), mapProjCode, position).then(() => {
        const layers = itvSoumFactory2.getitvoperationalLayers();
        for (let iLyr = 0; iLyr < layers.length; iLyr++) {
          const featLayer = layers[iLyr];
          const featLayerName = featLayer.getProperties().name;
          if (position == 'center') {
            position = 'canal';
          }
          if (position === featLayerName) {
            scope.map.getLayers().forEach(function (Layer) {
              if (featLayerName === Layer.getProperties().name) {
                removeLayer(scope, Layer);
              }
            });
            scope.map.getLayers().insertAt(featureLayerPos, featLayer);
          }
        }
        def.resolve();
      },
      () => {
        def.reject();
      });
      selectText(polygon);
      return def.promise;
    };


    /**
     *    Gestion du cas d'erreur en tentative de upload d'un fichier ITV.
     */
    const soumissionProgressionError = (data) => {
      require('toastr').clear();
      for (let ind = 0; ind < data.errorList.length; ind++) {
        let param = '',
          params = data.errorList[ind].kis_mess_params;
        if (params) {
          for (let iPar = 0; iPar < params.length; iPar++) {
            param += params[iPar];
          }
        }
        require('toastr').error(
          $filter('translate')(
            'itv.soumission.' + data.errorList[ind].message_kis
          ) + param
        );
      }
      if (data.errorList.length == 0)
        require('toastr').error(
          $filter('translate')('itv.soumission.existerreur')
        );
      gaDomUtils.hideGlobalLoader();
    };


    const partHeaderUnvalidated = (polygon) => {
      polygon.partHeader.validated = false;
    };


    const partHeaderValidated = (partHeader, otherParts, indTroncon) => {
      partHeader.validated = true;
      if (otherParts) {
        const part = otherParts[indTroncon];
        if (partHeader.partHeader) {
          partHeader = partHeader.partHeader;
        }
        const ind = part.partHeaders.findIndex((header) =>
          header.code === partHeader.code);
        if (ind != -1) {
          part.partHeaders[ind] = angular.copy(partHeader);
        }
      }
    };


    const getIndTronconFrom = (p) => {
      let part = p;
      if (p.part) {
        part = p.part;
      }
      if (part.objValeur) {
        return part.objValeur.indTroncon;
      }
      else if (part.partHeaders) {
        return part.partIndex;
      }
      else {
        return part.indTroncon;
      }
    };


    /**
     * Répercute la modification de AAD ver AAB ou l'inverse.
     *
     * @param {*} p
     * @param {*} indexXXX
     * @param {*} headerCode
     */
    const validSelectionManageHeaderCode = (scope, p, indexXXX, headerCode,
      from) => {
      //-- Exemple indexXXX = AAD et headerCode = AAB
      //-- Récup de AAD -> regard.10
      let headers;
      if (from === 'fromValidSelection') {
        //-- Depuis portion en cours de mise en correspodnance
        //-- avec contenu actualisé.
        headers = getHeadersFrom(scope.corresp.partHeaderAmont.part);
      }
      else {
        //-- Depuis données d'origine.
        headers = getHeadersFrom(p);
      }
      const indTroncon = getIndTronconFrom(p);
      let parthead = angular.copy(headers[indexXXX]);
      //-- On change le code AAD en AAB ce qui donne AAB -> regard.10
      parthead.code = parthead._code = headerCode;
      const codeOfPartHeadOther = parthead.code;
      //-- Recherche de AAB dans les headers
      const indexofheadersother = headers.findIndex(
        (header) => header.code === codeOfPartHeadOther);
      if (indexofheadersother != -1) {
        //-- AAB existe, on le remplace par le nouveau
        parthead.alias = headers[indexofheadersother].alias;
        headers[indexofheadersother] = parthead;
      }
      else {
        //-- AAB n'existe pas, on l'ajoute
        p.part.objValeur.headers.push(parthead);
      }
      const impoObjValeur = scope.information.impor.itvResponse.objValeur;
      const indexInfilesofNew = impoObjValeur.parts.map((x) => {
        return x.partIndex;
      }).indexOf(getIndTronconFrom(p.part));
      const partinitbobjofNew = impoObjValeur.parts[indexInfilesofNew]
        .partHeaders.findIndex(
          header => header ? header.code === codeOfPartHeadOther : true);
      if (indexofheadersother != -1) {
        impoObjValeur.parts[indexInfilesofNew]
          .partHeaders[partinitbobjofNew] = angular.copy(parthead);
      }
      else {
        impoObjValeur.parts[indexInfilesofNew].partHeaders.push(
          angular.copy(parthead));
      }
      const corresp = scope.information.correspondance;
      const ind = corresp.parts.partIndex.indexOf(indTroncon);
      corresp.parts.part[ind] = angular.copy(p.part);
    };


    const getNameIndex = (list, value) => {
      return list.findIndex((x) => x.name === value);
    };


    const updatePartHeader = (objValeur, polygon, codeofparthead) => {
      const indexInfiles = objValeur.parts.findIndex(
        (part) => part.partIndex === getIndTronconFrom(polygon.part));

      const part = objValeur.parts[indexInfiles];
      const partinitbobj = part.partHeaders.findIndex(
        header => header ? header.code === codeofparthead : true);

      if (partinitbobj != -1) {
        part.partHeaders[partinitbobj] = angular.copy(polygon.partHeader);
      }
      else {
        part.partHeaders.push(angular.copy(polygon.partHeader));
      }
      return indexInfiles;
    };


    const addPolygonsConstruct = (scope, name, polygon) => {
      if (name.indexOf('Amont') !== -1) {
        return constructFeature(scope, 'amont', polygon, scope.map, d3, 10);
      }
      else if (name.indexOf('Aval') !== -1) {
        return constructFeature(scope, 'aval', polygon, scope.map, d3, 11);
      }
      else if (name.indexOf('Center') !== -1) {
        itvSoumFactory2.clearoriginsourcecanal();
        return constructFeature(scope, 'center', polygon, scope.map,d3, 5);
      }
      else {
        return constructFeature(scope, 'alone', polygon, scope.map,d3, 12);
      }
    };


    let lastSave = {};

    const saveItvPart = (id, pn, sendata, network, datastore) => {
      // -- Eviter de faire plusieurs fois d'affilé la même sauvegarde
      if (lastSave.id === id && lastSave.pn === pn
        && Date.now() - lastSave.when < 500 && lastSave.sendata === sendata) {
        lastSave.when = Date.now();
        return lastSave.promise;
      }
      const promise = $http.post('/services/' + portalid +
        '/itv/{appname}/saveItvPart?f=json&itvid=' + id
        + '&partnumber=' + pn + '&network=' + network
        + '&arcgislayers=' + resources.readArcgisLayersFn()
        + '&datastore=' + datastore, sendata
      );
      // -- Enregistrer la sauvegarde effectivement faite
      lastSave.id = id;
      lastSave.pn = pn;
      lastSave.sendata = sendata;
      lastSave.when = Date.now();
      lastSave.promise = promise;

      promise.then(function (res) {
        let mess = '';
        if (res.data.etat === 'erreur') {
          for (let ind = 0; ind < res.data.errorList.length; ind++) {
            if (res.data.errorList[ind].message_kis) {
              mess += $filter('translate')(
                'itv.soumission.' + res.data.errorList[ind].message_kis
              );
            }
            if (res.data.errorList[ind].exception) {
              if (mess != '') mess += ' - ';
              mess += res.data.errorList[ind].exception;
            }
            require('toastr').error(mess);
          }
        }
      });

      return promise;
    };


    const addpolygons = (scope, polygon, doNotDraw) => {
      const def = $q.defer();
      var name = polygon.name;
      polygon.partHeader.featUid = polygon.id;
      if (polygon.feature) {
        itvSoumFactory2.setHeaderId(polygon.id, polygon.feature,
          polygon.partHeader);
        partHeaderValidated(polygon);
      }
      else {
        partHeaderUnvalidated(polygon);
      }

      var codeofparthead = polygon.partHeader.code;
      const headers = getHeadersFrom(polygon.part);
      const indexofheader = headers.findIndex(
        (x) => x.code === codeofparthead);
      headers[indexofheader] = angular.copy(polygon.partHeader);

      angular.forEach(scope.correspPolygons,(p) => {
        if (p.name !== name && p.part.objValeur) {
          const indexinOtherPolygon = p.part.objValeur.headers
            .findIndex( header => header.code===codeofparthead);
          p.part.objValeur.headers[indexinOtherPolygon]
              = angular.copy(polygon.partHeader);
        }
      }
      );

      const indexAAD = headers.findIndex((x) => x.code === 'AAD');
      const indexAAB = headers.findIndex((x) => x.code === 'AAB');

      if (codeofparthead == 'AAD') {
        validSelectionManageHeaderCode(scope, polygon, indexAAD, 'AAB');
      }
      else if (codeofparthead == 'AAB') {
        validSelectionManageHeaderCode(scope, polygon, indexAAB, 'AAD');
      }

      const corresp = scope.information.correspondance;
      const objValeur = scope.information.impor.itvResponse.objValeur;

      //-- On a validé, il faut donc prendre en compte la correspondance
      //-- définie par l'opérateur.
      const curHeaders = getHeadersFrom(corresp.parts.currentPolygon.part);
      const indexInfilescurrent = curHeaders.findIndex(
        (header) => header ? header.code === polygon.partHeader.code : true);
      curHeaders[indexInfilescurrent] = angular.copy(polygon.partHeader);

      const indInFile = updatePartHeader(objValeur, polygon, codeofparthead);
      const indTroncon = getIndTronconFrom(polygon.part);
      const Key = 'part' + indTroncon;
      corresp.parts.polygons[Key][name] = angular.copy(polygon);

      if (doNotDraw) {
        def.resolve();
      }
      else {
        addPolygonsConstruct(scope, name, polygon).then(() => {
          if ((polygon.partHeader.code === 'CAA' &&
            Object.keys(corresp.parts.polygons[Key]).length == 1) ||
            Object.keys(corresp.parts.polygons[Key]).length == 3) {
            if (polygon.part.objValeur) {
              polygon.part.objValeur.validated = true;
            }
            objValeur.parts[indInFile].matchedAutomatically
              = getCurrentPart(scope).validated
              = objValeur.parts[indInFile].validated = true;
            saveItvPart(objValeur.ItvId, indTroncon, polygon.part.objValeur,
              scope.conf.config.network, scope.conf.config.datastore);
          }
          def.resolve(polygon);
        });
      }
      return def.promise;
    };


    const getCurrentPart = (scope) => {
      const parts = scope.information.impor.itvResponse.objValeur.parts;
      return parts.find(part => part.$hideRows);
    };


    /**
     * Vérifie si la propriété featUid existe dans l'objet partHeader
     * de l'argument pa.
     * Si elle n'existe pas, mais que featUidMa existe,
     * définir featUid comme étant identique à featUidMa.
     *
     * @param {*} pa "polygon" schématique
     */
    const checkFeatureTypeUID = (pa) => {
      if (!pa.name.includes('Center') && !pa.partHeader.featUid
      && pa.partHeader.featUidMa) {
        pa.partHeader.featUid = pa.partHeader.featUidMa;
      }
    };

    const setReadArcgisLayersFn = (theFunction) => {
      resources.readArcgisLayersFn = theFunction;
    };


    return {
      getCodesOfPart: getCodesOfPart,
      removeLayerByName: removeLayerByName,
      removeLayers: removeLayers,
      removeLayer: removeLayer,
      constructFeature: constructFeature,
      selectText: selectText,
      soumissionProgressionError: soumissionProgressionError,
      getIdValue: getIdValue,
      addpolygons: addpolygons,
      partHeaderValidated: partHeaderValidated,
      validSelectionManageHeaderCode: validSelectionManageHeaderCode,
      getNameIndex: getNameIndex,
      getCurrentPart: getCurrentPart,
      getHeadersFrom: getHeadersFrom,
      getIndTronconFrom: getIndTronconFrom,
      saveItvPart: saveItvPart,
      getitvoperationalLayers: itvSoumFactory2.getitvoperationalLayers,
      clearitvoperationalLayers: itvSoumFactory2.clearitvoperationalLayers,
      drawFeature: itvSoumFactory2.drawFeature,
      clearoriginsourcecanal: itvSoumFactory2.clearoriginsourcecanal,
      itvUtilsFactory: itvSoumFactory2.itvUtilsFactory,
      setHeaderId: itvSoumFactory2.setHeaderId,
      clearAllSources: itvSoumFactory2.clearAllSources,
      getPortalId: getPortalId,
      clearHeaderIds: itvSoumFactory2.clearHeaderIds,
      originSourceCANAL: itvSoumFactory2.originSourceCANAL,
      checkFeatureTypeUID,
      setReadArcgisLayersFn
    };
  };
  itvUtilsFactory.$inject = ['itvSoumFactory2', '$q', 'gaDomUtils',
    '$filter', '$http','PortalsFactory'];
  return itvUtilsFactory;
});
