'use strict';
define(function() {
  var gcelement = function(NetworkFactory, $timeout) {
    return {
      templateUrl: 'js/XG/widgets/utilities/network/views/gcnetworks.html',
      restrict: 'A',
      scope: {
        selectednetwork: '=selectednetwork',
        onselect: '&',
      },
      link: function(scope, element, attrs, ctrl) {
        scope.currentnetwork = null;
        scope.networks = [];

        loadNetworks();

        function loadNetworks() {
          if (NetworkFactory.resources.networks.length == 0) {
            NetworkFactory.get().then(function() {
              scope.networks = NetworkFactory.resources.networks;
            });
          } else scope.networks = NetworkFactory.resources.networks;
        }

        scope.networkChange = function(selNetwork) {
          scope.selectednetwork = selNetwork;
          $timeout(scope.onselect, 100);
        };
      },
    };
  };

  gcelement.$inject = ['NetworkFactory', '$timeout'];
  return gcelement;
});
